/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills;

import dev.toma.gunsrpg.api.common.attribute.IValueFormatter;
import dev.toma.gunsrpg.api.common.skill.IDescriptionProvider;
import dev.toma.gunsrpg.common.skills.SimpleSkill;
import dev.toma.gunsrpg.common.skills.core.DescriptionContainer;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.object.Pair;
import net.minecraft.util.text.ITextComponent;

public class LumberjackSkill
extends SimpleSkill
implements IDescriptionProvider {
    private static final ChancesContainer[] data = new ChancesContainer[]{new ChancesContainer(0.1f, 0.2f), new ChancesContainer(0.25f, 0.4f), new ChancesContainer(0.4f, 0.6f), new ChancesContainer(0.55f, 0.8f), new ChancesContainer(0.7f, 0.95f)};
    private final DescriptionContainer container;
    private final int level;

    public LumberjackSkill(SkillType<?> type, int level) {
        super(type);
        this.level = level;
        this.container = new DescriptionContainer(type);
        LumberjackSkill.data[level - 1].append(this.container);
    }

    @Override
    public ITextComponent[] supplyDescription(int desiredLineCount) {
        return this.container.getLines();
    }

    public Pair<Float, Float> getDropChances() {
        ChancesContainer chancesContainer = data[this.level - 1];
        return Pair.of(Float.valueOf(chancesContainer.extraPlanks), Float.valueOf(chancesContainer.extraSticks));
    }

    private static final class ChancesContainer {
        private final float extraPlanks;
        private final float extraSticks;

        public ChancesContainer(float extraPlanks, float extraSticks) {
            this.extraPlanks = extraPlanks;
            this.extraSticks = extraSticks;
        }

        private void append(DescriptionContainer container) {
            container.addProperty("plank", IValueFormatter.PERCENT.formatAttributeValue(this.extraPlanks));
            container.addProperty("stick", IValueFormatter.PERCENT.formatAttributeValue(this.extraSticks));
        }
    }
}

